
//定义弹出层，弹出工作条方法
var commentPopupbox,
	commentToolbar;

(function($){

	/*测量元素大小，用于定位元素居中*/
	var elementSize = function(el){

		var _width = el.width(),
			_height = el.height();

		return {
			width : _width,
			height : _height
		}
	}

	commentPopupbox = function(str){
		var ele = $(str);

		var _popupboxOpen = function(){
			ele.show();
			_popupboxSetPosition(ele);
		}

		var _popupboxClose = function(){
			ele.hide();
		}

		/*弹出层定位*/
		var _popupboxSetPosition = function(element){
			var pos = elementSize(element);
			element.css({
				"margin-left": -pos.width/2,
				"margin-top": -pos.height/2
			});
		}

		var _init = function(){

			_popupboxSetPosition(ele);
		}

		_init();

		return {
			open : _popupboxOpen ,
			close : _popupboxClose
		}
	}


	commentToolbar = function(str){
		var ele = $(str),
			currentTool = "";

		var openToolbar = function(el){
			el.show();
			currentTool = el;
		}

		var closeToolbar = function(el){
			el.hide();
			currentTool = "";
		}


		var _init =function(){

			//绑定评论触摸事件
			ele.on('click', 'li', function(event) {

				var cT = $( event.currentTarget ),
					touchPosition = {};

				touchPosition = {
					top : event.clientY,
					left : event.clientX
				}

				console.log(cT.offset().top);

				var sitem = $(this).children(".tooltip-layer");

				//检查是否点击当前元素，点击当前打开元素则关闭元素，点击其他元素，关闭当前元素
				if( currentTool !== "" )
				{
					if( currentTool.get(0) == sitem.get(0) )
					{
						closeToolbar(sitem);
					}
					else{
						closeToolbar(currentTool);
					}
				}

				//
				if( !sitem.width())//检查元素是否可见，隐藏元素没有宽高
				{
					openToolbar(sitem);
					sitem.css('margin-left', - elementSize(sitem).width / 2 );//打开元素后，检测元素宽度，定位
				}
				else{
					closeToolbar(sitem);
				}


				if( cT.offset().top > sitem.height() + 20 && cT.offset().top > 200 )
				{
					sitem.css('margin-top', - elementSize(sitem).height / 2);
				}
				else{
					sitem.css('margin-top', elementSize(sitem).height / 2 + 20 );
					sitem.addClass('tooltip-layer-bottom');
				}
				console.log(event);

				event.preventDefault();
				/* Act on the event */
			});

			//滚动的时候隐藏动作条
			ele.get(0).ontouchmove = function(){
				if( currentTool ){
					currentTool.hide();
				}
			}

		}
		_init();

	}
	
})(Zepto)