
        function hasClass(obj, cls) {
            return obj.className.match(new RegExp('(\\s|^)' + cls + '(\\s|$)'));
        }

        function addClass(obj, cls) {
            if (!this.hasClass(obj, cls)) obj.className += " " + cls;
        }

        function removeClass(obj, cls) {
            if (hasClass(obj, cls)) {
                var reg = new RegExp('(\\s|^)' + cls + '(\\s|$)');
                obj.className = obj.className.replace(reg, ' ');
            }
        }

		(function(){
			var arr_item = [];//存储要绑定事件的对象
			var index_head = document.getElementById('battle-info-head');
			var page_head = document.getElementById('page-title-head');
			if(index_head)
			{
				var arr_link = index_head.getElementsByClassName('nav-item');
				for(var j=0; j < arr_link.length;j++)
				{
					arr_item.push(arr_link[j]);
				}
			}
			if(document.getElementById('site-search-bar'))
			{
				var title = page_head.getElementsByTagName('h2')[0];
				var search_bar = document.getElementById('site-search-bar');
				var search_btn = page_head.getElementsByClassName('btn-search')[0];
				search_btn.onclick = function(){
					if(title.style.display !== "none")
					{
						search_bar.style.display = "block";
						title.style.display = "none";
					}
					else{
						search_bar.style.display = "none";
						title.style.display = "block";
					}
				}
			}
			if(page_head)
			{
				if(page_head.getElementsByClassName('btn-back')[0])
				{
					arr_item.push(page_head.getElementsByClassName('btn-back')[0]);
				}
				if(page_head.getElementsByClassName('btn-search')[0])
				{
					arr_item.push(page_head.getElementsByClassName('btn-search')[0]);
				}
				if(page_head.getElementsByClassName('btn-share')[0])
				{
					arr_item.push(page_head.getElementsByClassName('btn-share')[0]);
				}
				if(page_head.getElementsByClassName('btn-flash')[0])
				{
					arr_item.push(page_head.getElementsByClassName('btn-flash')[0]);
				}
			}

			for(var i = 0;i <= arr_item.length - 1; i++)
			{
				arr_item[i].ontouchstart = function(){
					addClass(this,"touch-hover");
				}
				arr_item[i].ontouchmove = function(){
					removeClass(this,"touch-hover");
				}
				arr_item[i].ontouchend = function(){
					removeClass(this,"touch-hover");
				}				
			}

		})()